#! /bin/bash

# <codex>
# <abstract>Script to remove everything installed by the sample.</abstract>
# </codex>

# This uninstalls everything installed by the sample.  It's useful when testing to ensure that 
# you start from scratch.

if [ `whoami` != root ]; then
    echo "This script must be run with admin privileges"
    exit
fi

# bold=$(tput bold) normal=$(tput sgr0)

DATE=$(date +%Y-%m-%d_%H:%M)

echo "[1/5] Quitting Endurance..."
set -x
killall Endurance
set +x
echo "Done"
echo ""

echo "[2/5] Quitting helper tool..."
set -x
launchctl unload /Library/LaunchDaemons/com.MagnetismStudios.endurance.helper.plist
result=$?
security -q authorizationdb remove "com.MagnetismStudios.endurance.readLicenseKey"
security -q authorizationdb remove "com.MagnetismStudios.endurance.writeLicenseKey"
security -q authorizationdb remove "com.MagnetismStudios.endurance..startWebService"
rm -fv /Library/LaunchDaemons/com.MagnetismStudios.endurance.helper.plist
rm -fv /Library/PrivilegedHelperTools/com.MagnetismStudios.endurance.helper
set +x
if [ "$result" -eq "0" ]; then echo "Helper tool removal: Success"; else echo "Helper tool removal: Failed"; fi
echo "Done"
echo ""

echo "[3/5] Removing kext, if installed..."
set -x
kextunload -b com.MagnetismStudios.cputune
set +x
kextstat | grep com.Magnetism
result=$?
if [ "$result" -eq "1" ]; then echo "Kext removal: Success"; else echo "Kext removal: Failed"; fi
echo "Done"
echo ""


echo "[4/5] Removing preference pane..."
set -x
killall "System Preferences"
mv "$HOME/Library/PreferencePanes/Endurance.prefpane/" "$HOME/.Trash/Endurance ($DATE).prefpane "
set +x
echo "Done"
echo ""

echo "[5/5] Removing Endurance app and preferences..."
set -x

if appLocation=$(su $USER -c "defaults read com.MagnetismStudios.endurance AppLocation | grep Endurance.app"); then
    mv "${appLocation/#\~/$HOME}" "$HOME/.Trash/Endurance ($DATE).app"
fi

if appLocation=$(su $USER -c "defaults read com.magnetism.endurance-setapp AppLocation | grep Endurance.app"); then
    mv "${appLocation/#\~/$HOME}" "$HOME/.Trash/Endurance (Setapp $DATE).app"
fi

su $USER -c "defaults delete com.MagnetismStudios.endurance 2> /dev/null"
su $USER -c "defaults delete com.magnetism.endurance-setapp 2> /dev/null"

set +x
echo "Done"
echo ""
